{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 30/07/04
 * Ultim dia:  02/10/04
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitCalculsLPC;

{**************************************************************}
interface
{**************************************************************}

Uses UnitDades;

//BEGIN Dades per LPC
Const
  MaximDadesInicialLPC = MaximNumerosBufferEntradaDeSo;

type
  NumerosEntradaLPC = array[0..MaximDadesInicialLPC] of single;
//END Dades per LPC

procedure CalculFuncioTransferenciaLPC({Entrada}NumeroDeDadesInicialsLPC:integer;NumerosPerCalcularLPC:NumerosEntradaLPC;NumeroQuoeficientsLPC:integer;NumeroPuntsFuncioDeTransferencia:integer;{Sortida}var FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY:NumerosPerCalcular);

{**************************************************************}
implementation
{**************************************************************}

uses sysutils;

const
  N = MaximDadesInicialLPC; //Nombre de dades
  MaximP = 128; //Nombre quoeficients LPC

var
  x:array[0..N] of single;
  q:array[0..MaximP] of single;
  r:array[0..MaximP] of single;
  E:array[0..MaximP] of single;
  k:array[1..MaximP] of single;
  alfa:array[1..MaximP,1..MaximP] of single;
  a:array[1..MaximP] of single; //Coeficients LPC
  g:array[1..MaximP] of single; //Coeficients
  h:array[0..N] of single; //Funci de transferncia

procedure CalculFuncioTransferenciaLPC({Entrada}NumeroDeDadesInicialsLPC:integer;NumerosPerCalcularLPC:NumerosEntradaLPC;NumeroQuoeficientsLPC:integer;NumeroPuntsFuncioDeTransferencia:integer;{Sortida}var FuncioDeTransferenciaLPCX,FuncioDeTransferenciaLPCY:NumerosPerCalcular);
var
  i,j:integer;
  m:integer;
  pr,pi:single;
  Nm:integer;
  CalculsDePi:single;
  CalculsDePiPerM:single;
begin
  for i:=1 to NumeroPuntsFuncioDeTransferencia do FuncioDeTransferenciaLPCX[i]:=(i-1)*FrequenciaDeMostreigEntradaSo/(2*NumeroPuntsFuncioDeTransferencia);
  for i:=0 to N do x[i]:=0;
  for i:=0 to MaximP do r[i]:=0;

  //25/10/04
  Nm:=NumeroDeDadesInicialsLPC-1;
  //Nm:=NumeroDeDadesInicialsLPC;
  for i:=0 to Nm do x[i]:=NumerosPerCalcularLPC[i];
  for i:=0 to NumeroQuoeficientsLPC do q[i]:=0;
  //for i:=0 to P do q[i]:=0;
  //Calcul dels quoeficients d'autocorrelaci
  for i:=0 to NumeroQuoeficientsLPC do r[i]:=0;
  for m:=0 to NumeroQuoeficientsLPC do for i:=0 to N-1-m do r[m]:=r[m]+x[i]*x[i+m];
  if r[0]=0 then begin
    for i:=0 to Nm do FuncioDeTransferenciaLPCY[i]:=0;
    exit;
  end;
  //LPC Anlisi. Mtode de Levinson-Durbin
  E[0]:=r[0];
  k[1]:=r[1]/E[0];
  alfa[1,1]:=k[1];
  E[1]:=(1-k[1]*k[1])*E[0];
  for i:=2 to NumeroQuoeficientsLPC do begin
    k[i]:=0;
    for j:=1 to i-1 do k[i]:=k[i]+alfa[j,i-1]*r[i-j];
    k[i]:=(r[i]-k[i])/E[i-1];
    alfa[i,i]:=k[i];
    for j:=1 to i-1 do alfa[j,i]:=alfa[j,i-1]-k[i]*alfa[i-j,i-1];
    E[i]:=(1-k[i]*k[i])*E[i-1];
  end;
  // a coeficients LPC
  for i:=1 to NumeroQuoeficientsLPC do a[i]:=alfa[i,NumeroQuoeficientsLPC];
  //K[i] PARCOR Coefficients
  //log area ratio coefficients
  for i:=1 to NumeroQuoeficientsLPC do g[i]:=ln((1-k[i])/(1+k[i]))/ln(10);
  //Funci de transferncia
  //Versi 31/07/04. s diferent de l'original per poder canviar el nmero de Punts a calcular
  //de la funci de transferncia
  CalculsDePi:=3.1416/(NumeroPuntsFuncioDeTransferencia-1);
  for m:=1 to NumeroPuntsFuncioDeTransferencia do begin
    Pr:=1;
    Pi:=0;
    CalculsDePiPerM:=(m-1)*CalculsDePi;
    for i:=1 to NumeroQuoeficientsLPC do begin
      Pr:=Pr-a[i]*cos(i*CalculsDePiPerM);
      Pi:=Pi+a[i]*sin(i*CalculsDePiPerM);
    end;
    //es pot calcular el logaritme decimal
    H[m]:=1/sqrt(Pr*Pr+Pi*Pi);
    //Quoeficient que m'he inventat d'ajust
    //FuncioDeTransferenciaLPCY[m]:=4*H[m];
    FuncioDeTransferenciaLPCY[m]:=H[m];
  end;
  //FuncioDeTransferenciaLPCY[0]:=0;
end;

{**************************************************************}
var
  i:integer;
begin
  for i:=0 to N do begin
    x[i]:=0;
    //NumerosInicalsLPC[i]:=0;
  end;
  for i:=0 to MaximP do r[i]:=0;
end.
